<?php

namespace App;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class SiteRepository
{
    public function vehicleUrl(Vehicle $vehicle, bool $withAccess = false): ?string
    {
        try {
            $access =  '?' . http_build_query([
                    'a' => base64_encode($vehicle->id . '-' . $vehicle->slug),
                ]);
            return $this->baseUrl() . '/vehicle/' . $vehicle->slug . ($withAccess ? $access : '');
        } catch (ModelNotFoundException $exception) {
            return null;
        }
    }

    public function offerUrl(VehicleOffer $offer, bool $withAccess = false): ?string
    {
        try {
            $access = '?' . http_build_query([
                    'a' => base64_encode($offer->id . '-' . $offer->slug),
                ]);
            return $this->baseUrl() . '/offer/' . $offer->slug . ($withAccess ? $access : '');
        } catch (ModelNotFoundException $exception) {
            return null;
        }
    }

    public function newCarUrl(NewCar $newCar, bool $withAccess = false): ?string
    {
        try {
            $access = '?' . http_build_query([
                    'a' => base64_encode($newCar->id . '-' . $newCar->slug),
                ]);
            return $this->baseUrl() . '/new/' . $newCar->slug . ($withAccess ? $access : '');
        } catch (ModelNotFoundException $exception) {
            return null;
        }
    }

    public function url(string $endpoint = ''): ?string
    {
        try {
            return $this->baseUrl() . '/' . ltrim($endpoint, '/');
        } catch (ModelNotFoundException $exception) {
            return null;
        }
    }

    protected function baseUrl(): string
    {
        $domain = tenant()->domains()
            ->where('verified', 1)
            ->orderByDesc('primary')
            ->firstOrFail();

        $protocol = config('app.env') === 'local' ? 'http://' : 'https://';

        return $protocol . $domain->domain;
    }
}
