<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class AnalyticsTracker implements Arrayable
{
    public function toArray()
    {
        $value = Settings::get('seo-ga_id');
        return [
            ['src' => 'https://www.googletagmanager.com/gtag/js?id=' . $value, 'data-consent' => 'analytical'],
            [
                'body' => "window.dataLayer = window.dataLayer || [];"
                    . "function gtag(){dataLayer.push(arguments);}gtag('js', new Date());gtag('config', '$value');",
                'data-consent' => 'analytical'
            ]
        ];
    }
}
