<?php

namespace App\Http\Resources;

use App\Traits\HasPlaceholderImage;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Property;
use Mtc\MercuryDataModels\PropertyAttributeValue;

class PropertyEntryList extends JsonResource
{
    use HasPlaceholderImage;

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(Property $property) => $this->map($property));
        return parent::toArray($request);
    }

    public function map(Property $property): array
    {
        $property->makeHidden([
            'id',
            'active',
            'created_at',
            'updated_at',
            'category_id',
            'attribute_values',
            'attributeValues',
        ]);

        collect($property->attributeValues)
            ->each(function (PropertyAttributeValue $attribute) use ($property) {
                if ($attribute->propertyField->type === 'image') {
                    $property[$attribute->slug] = $this->getGallery($attribute);
                } else {
                    $property[$attribute->slug] = $attribute->getValue();
                }
            });

        return $property->toArray();
    }

    protected function largeImageDimensions(): string
    {
        return 'large';
    }

    protected function mediumImageDimensions(): string
    {
        return 'square';
    }

    protected function thumbnailImageDimensions(): string
    {
        return 'thumb';
    }
}
