<?php

namespace App\Traits;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

trait CacheObject
{
    protected function cache(string $key, int $lifetime, \Closure $closure)
    {
        return Cache::remember(tenant('id') . '-' . $key, $this->cacheLife($lifetime), $closure);
    }

    private function cacheLife(int $lifetime): Carbon
    {
        return Carbon::now()->addMinutes(app()->environment('production') ? $lifetime : 0);
    }
}
