<?php

namespace App\Traits;

use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleTrim;

trait VehicleOfferData
{
    protected function getOfferSupportingData(int $make_id): array
    {
        $make_offers = VehicleOffer::query()
            ->where('make_id', '=', $make_id)
            ->where('published', '=', true)
            ->get();

        $models = [];
        $models['all'] = [
            'id' => null,
            'name' => 'all',
            'fuel_types' => [],
            'trims' => [],
            'availability_types' => [],
        ];

        $make_offers->each(function ($offer) use (&$models) {
            if (!array_key_exists($offer->model_id, $models)) {
                $model = VehicleModel::query()
                    ->where('id', '=', $offer->model_id)
                    ->first();

                $models[$offer->model_id] = [
                    'id' => $offer->model_id,
                    'name' => $model->id,
                    'fuel_types' => [],
                    'trims' => [],
                    'availability_types' => [],
                ];
            }

            if (!empty($offer->fuel_type_id)) {
                $fuel = FuelType::query()
                    ->select('id', 'name')
                    ->where('id', '=', $offer->fuel_type_id)
                    ->first()
                    ->attributesToArray();

                $models['all']['fuel_types'][$offer->fuel_type_id] = $fuel;
                $models[$offer->model_id]['fuel_types'][$offer->fuel_type_id] = $fuel;
            }

            if (!empty($offer->trim)) {
                $trim = VehicleTrim::query()
                    ->select('id', 'name')
                    ->where('name', '=', $offer->trim)
                    ->first()
                    ->attributesToArray();

                $models['all']['trims'][$offer->trim] = $trim;
                $models[$offer->model_id]['trims'][$offer->trim] = $trim;
            }

            if (!empty($offer->new_car_type)) {
                $models['all']['availability_types'][$offer->new_car_type] = $offer->new_car_type;
                $models[$offer->model_id]['availability_types'][$offer->new_car_type] = $offer->new_car_type;
            }
        });

        return $models;
    }
}
