<?php

declare(strict_types=1);

use App\Http\Controllers\ConversionController;
use App\Http\Controllers\DealershipController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\FinanceController;
use App\Http\Controllers\FranchiseController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\NewCarController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\ServiceBookingController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\ValuationController;
use App\Http\Controllers\VehicleController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use App\Http\Middleware\SeoRedirectCheckMiddleware;
use App\Http\Middleware\SetStatefulDomainForTenant;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use App\Middleware\InitializeTenancyByDomain;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProauvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
    InitializeTenancyByDomain::class,
    \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
])->prefix('frontend/')->group(function (Router $router) {

    $router->get('/get-site', [SiteController::class, 'index'])->name('get-site');

    Route::middleware([
        PreventRequestsIfTenantSuspended::class,
        SeoRedirectCheckMiddleware::class,
    ])->group(function (Router $router) {
        $router->get('/paginated-listing/{type}', [PageController::class, 'paginatedListing'])
            ->where('type', 'news|blog')->name('paginated-listing');
        $router->post('verify-access', [SiteController::class, 'checkAccess'])->name('check-site-access');
        $router->post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter-signup');
        $router->post('/enquiries', [EnquiryController::class, 'store'])->name('enquiries.store');
        $router->get('/pages/{page}', [PageController::class, 'show'])->name('pages.show');
        $router->get('/global-content/{content}', [PageController::class, 'globalContent'])->name('pages.get-global');

        $router->post('/find-vehicle', [FilterController::class, 'index'])->name('vehicles.index');
        $router->post('/find-vehicle/widget', [FilterController::class, 'widget'])->name('vehicles.widget');
        $router->post('/vehicles/{vehicle:slug}/finance', [FinanceController::class, 'store'])->name('vehicles.get-finance');
        $router->get('/vehicles/{vehicle:slug}/quick-view', [VehicleController::class, 'quickView'])
            ->name('vehicles.quick-view');
        $router->get('/vehicles/{vehicle:slug}', [VehicleController::class, 'show'])->name('vehicles.show');
        $router->get('/recent-vehicles/{vehicle:slug?}', [VehicleController::class, 'recentlyViewed'])
            ->name('vehicles.recentlyViewed');
        $router->get('/compare-vehicles', [VehicleController::class, 'compare'])->name('vehicles.compare');
        $router->get('/recently-added-vehicles', [VehicleController::class, 'recentlyAdded'])
            ->name('vehicles.recentlyAdded');
        $router->any('/featured-vehicles/{vehicle:slug?}', [VehicleController::class, 'featured'])
            ->name('vehicles.featured');
        $router->any('/similar-vehicles/{vehicle:slug}', [VehicleController::class, 'similar'])
            ->name('vehicles.similar');

        $router->get('/valuations', [ValuationController::class, 'show'])->name('valuations.show');
        $router->post('/valuations', [ValuationController::class, 'get'])->name('valuations.get');
        $router->get('/dealerships/{dealership:slug}', [DealershipController::class, 'show'])->name('dealerships.show');
        $router->get('/dealerships', [DealershipController::class, 'index'])->name('dealerships.index');

        $router->get('/franchises/{franchise:slug}', [FranchiseController::class, 'show'])->name('franchises.show');
        $router->get('/franchises/{franchise:slug}/offers', [FranchiseController::class, 'offers'])->name('franchises.offers');

        $router->post('/properties/{category:slug}', [PropertyController::class, 'index'])->name('properties.index');
        $router->get('/properties/{category:slug}/{property:slug}', [PropertyController::class, 'show'])->name('properties.show');

        $router->post('/offers', [OfferController::class, 'index'])->name('offers.index');
        $router->post('/offers/{make}', [OfferController::class, 'search'])->name('offers.search');
        $router->get('/offers/{offer:slug}', [OfferController::class, 'show'])->name('offers.show');

        $router->post('/new-cars/{make}', [NewCarController::class, 'search'])->name('new-cars.search');
        $router->get('/new-cars/{car:slug}', [NewCarController::class, 'show'])->name('new-cars.show');

        $router->post('/conversion/track', [ConversionController::class, 'store'])->name('conversions.track');

        $router->post('/service-booking/vehicle-lookup', [ServiceBookingController::class, 'vehicleLookup'])->name('bookings.lookup');
        $router->post('/service-booking/set-location', [ServiceBookingController::class, 'setLocation'])->name('bookings.location');
        $router->post('/service-booking/set-package', [ServiceBookingController::class, 'setPackage'])->name('bookings.package');
        $router->post('/service-booking/availability', [ServiceBookingController::class, 'getAvailability'])->name('bookings.availability');
        $router->post('/service-booking/set-time', [ServiceBookingController::class, 'setAvailability'])->name('bookings.set-availability');
        $router->post('/service-booking/set-delivery', [ServiceBookingController::class, 'setDelivery'])->name('bookings.delivery');
        $router->post('/service-booking/book', [ServiceBookingController::class, 'store'])->name('bookings.book');
    });
});
