<?php

namespace App\Http\Controllers;

use App\Http\Resources\DealershipList;
use App\Http\Resources\DealershipView;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Services\LocatingService;

class DealershipController extends Controller
{
    public function index(Request $request, LocatingService $service)
    {
        return new DealershipList(Dealership::query()
            ->where('active', 1)
            ->with([
                'mediaUses.media',
                'franchise',
            ])
            ->nearPostcode($request->input('postcode'))
            ->get());
    }

    public function show(Dealership $dealership)
    {
        if (!$dealership->active) {
            return response('Not Found', 404);
        }
        return new DealershipView($dealership);
    }
}
