<?php

namespace App\Http\Controllers;

use App\Http\Resources\PropertyEntry;
use App\Http\Resources\PropertyEntryList;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Property;
use Mtc\MercuryDataModels\PropertyCategory;

class PropertyController extends Controller
{
    public function index(Request $request, PropertyCategory $category)
    {
        return new PropertyEntryList($category->properties()
            ->orderBy('order')
            ->with([
                'attributeValues.mediaUses.media',
                'attributeValues.propertyField',
            ])
            ->filter($category, $request)
            ->paginate($request->input('per_page')));
    }

    public function show($category, $property)
    {
        $property = Property::query()->where('slug', $property)
            ->whereHas('category', fn($query) => $query->where('slug', $category))
            ->firstOrFail();
        if (!$property->active) {
            return response('Not found', 404);
        }

        return new PropertyEntry($property);
    }
}
