<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class CalltracksTracking implements Arrayable
{
    public function toArray()
    {
        $system = Settings::get('crm-calltracks-system');

        return [
            [
                "body" => '(function(){
                   e=document.createElement("script");
                   e.type="text/javascript",
                   e.async=1,
                   e.src="//' . $system . '.calltracks.com/wnd/loader.js?force_tracking=1";
                   document.getElementsByTagName("head")[0].appendChild(e);
                 })();',
                'data-consent' => 'analytical'
            ]
        ];
    }
}
