<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\ContentManager\Factories\MediaSizeFactory;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\MediaUse;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class DealershipControllerTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testDealershipIndex()
    {
        Dealership::factory(3)->create();
        $response = $this->asTenant(tenant())
            ->getJson(route('dealerships.index'));

        $response->assertStatus(200);
        $this->assertArrayHasKey('page', $response->json());
        $this->assertArrayHasKey('dealerships', $response->json());
    }

    public function testDealershipShow()
    {
        $dealership = Dealership::factory()->create();
        $response = $this->asTenant(tenant())
            ->getJson(route('dealerships.show', $dealership));

        $response->assertStatus(200);
    }

    public function testMedia()
    {
        MediaSize::factory(3)->create([
            'model' => 'dealership',
        ]);

        $dealership = Dealership::factory()->create();
        $media_item = Media::factory()->create();
        MediaUse::factory()->create([
            'media_id' => $media_item->id,
            'owner_type' => 'dealership',
            'owner_id' => $dealership->id
        ]);

        $response = $this->asTenant(tenant())
            ->getJson(route('dealerships.show', $dealership));

        $response->assertStatus(200);

        $this->assertCount(1, $response->json('images'));
        $this->assertCount(3, $response->json('images.0.sizes'));

        foreach ($response->json('images.0.sizes') as $size_name => $size_path) {
            $this->assertStringContainsString($media_item->src, $size_path);
        }
    }
}
