<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\MercuryDataModels\Page;
use Tests\TestCase;

class PageControllerTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testShowPageEndpoint()
    {
        Page::factory()->create(['title' => 'foo baz bar', 'slug' => 'home', 'status' => 'published']);

        $response = $this->asTenant(tenant())
            ->getJson(route('pages.show', 'home'));
        $response->assertStatus(200);

        $this->assertEquals('home', $response->json('slug'));
        $this->assertEquals('foo baz bar', $response->json('title'));
    }

    public function testShowGlobalContentEndpoint()
    {
        GlobalContent::factory()->create([
            'name' => 'foo baz bar',
            'slug' => 'foo',
            'content' => ['foo' => 'baz']
        ]);

        $response = $this->asTenant(tenant())
            ->getJson(route('pages.get-global', 'faz'));
        $response->assertStatus(404);

        $response = $this->asTenant(tenant())
            ->getJson(route('pages.get-global', 'foo'));
        $response->assertStatus(200);

        $this->assertEquals('baz', $response->json('foo'));
    }

    public function testGetSiteEndpoint()
    {
        Page::factory()->create(['title' => 'foo baz bar', 'slug' => 'home']);

        $response = $this->asTenant(tenant())
            ->getJson(route('get-site'));
        $response->assertStatus(200);

        $this->assertEquals(tenant('id'), $response->json('id'));
    }
}
