<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use App\Modules\Valuation\Config\AutoTrader;
use App\Modules\Valuation\Config\CapConfig;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\FilterSettingSeed;
use Tests\TestCase;

class ValuationConfigTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testCapConfig()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-subscriber_id',
            'value' => 'abc-123',
            'type' => 'string',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-password',
            'value' => 'foo-baz',
            'type' => 'secret',
        ]);

        /** @var CapConfig $config */
        $config = App::make(CapConfig::class);

        $this->assertTrue($config->enabled());
        $this->assertEquals('abc-123', $config->subscriberId());
        $this->assertEquals('foo-baz', $config->password());
    }

    public function testAutoTraderConfig()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-auto-trader-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'auto-trader-advertiser-id',
            'value' => 'abc-123',
            'type' => 'string',
        ]);
        /** @var AutoTrader $config */
        $config = App::make(AutoTrader::class);

        $this->assertTrue($config->enabled());
        $this->assertEquals('abc-123', $config->merchantId());
    }
}
