<?php

namespace App\Http\Resources;

use App\TierHelper;
use Mtc\MercuryDataModels\Franchise;

trait FranchiseData
{
    protected function getFranchiseList(): array
    {
        if (!$this->tenantIsAllowedFranchises()) {
            return [];
        }

        return Franchise::query()->select(['name', 'slug'])->get()->toArray();
    }
    protected function isFranchise(): bool
    {
        if ($this->tenantIsAllowedFranchises() || empty($this->resource)) {
            return false;
        }

        if (!empty($this->resource->franchise_id)) {
            return true;
        }

        return $this->resource?->template?->slug === 'franchise';
    }

    protected function franchiseData(): ?array
    {
        if ($this->isFranchise() !== true) {
            return null;
        }

        return Franchise::query()
            ->with('menus')
            ->find($this->resource->franchise_id)
            ?->only([
                'name',
                'slug',
                'logo',
                'primary_colour',
                'secondary_colour',
                'menus',
            ]);
    }


    protected function getFranchiseId(): int
    {
        return 0;
    }

    protected function tenantIsAllowedFranchises(): bool
    {
        return TierHelper::isAllowed(tenant()->tier, 'pro');
    }
}
