<?php

namespace App\Modules\Stock;

use App\Contracts\ExternalMediaUrlProvider;
use Mtc\ContentManager\Contracts\Media;

class Motordat implements ExternalMediaUrlProvider
{
    public function url(Media $media, string $size): string
    {
        $size = $this->mapImageDimensions($size);
        return "https://motordat-img-1.motordat.com/images/$size/" . ltrim($media->src, '/');
    }

    private function mapImageDimensions(string $size): string
    {
        return match ($size) {
            'smallthumbs' => 'smallthumbs',
            'thumbs' => 'thumbs',
            'original' => 'verylarge',
            'large' => 'verylarge',
            default => 'large',
        };
    }
}
