<?php

namespace App;

use App\Facades\Settings;
use App\Http\Resources\OfferListResource;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferRepository
{
    public function similar(VehicleOffer $offer, int $limit = 4, string $matchType = 'price'): OfferListResource
    {
        return new OfferListResource(
            VehicleOffer::query()
                ->with([
                    'make.filterIndex',
                    'model.filterIndex',
                    'primaryMediaUse.media',
                    'dealership',
                ])
                ->when(
                    Settings::get('offer-list-load-features'),
                    fn($query) => $query->with('features')
                )
                ->active()
                ->similar($matchType, $offer)
                ->where('id', 'not like', $offer->id)
                ->take($limit * 2)
                ->get()
                ->shuffle()
                ->take($limit)
        );
    }

    public function featuredByModel(int $modelId, int $limit = 8): OfferListResource
    {
        return new OfferListResource(
            VehicleOffer::query()
                ->with([
                    'make.filterIndex',
                    'model.filterIndex',
                    'primaryMediaUse.media',
                    'dealership',
                ])
                ->when(
                    Settings::get('offer-list-load-features'),
                    fn($query) => $query->with('features')
                )
                ->where('featured', 1)
                ->active()
                ->where('model_id', $modelId)
                ->take($limit * 2)
                ->get()
                ->shuffle()
                ->take($limit)
        );
    }
}
