<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Franchise;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Template;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class FranchiseDataTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testFranchiseData()
    {
        tenant()->update(['tier' => 'pro']);
        $franchise = Franchise::factory()->create([
            'name' => 'foo',
            'slug' => 'baz'
        ]);

        $template = Template::factory()->create(['slug' => 'franchise']);
        $page = Page::factory()->create(['status' => 'published', 'template_id' => $template->id]);
        $response = $this->asTenant(tenant())
            ->getJson(route('pages.show', $page->slug));

        $response->assertStatus(200);
    }

    public function testDealershipFranchise()
    {
        $franchise = Franchise::factory()->create([
            'name' => 'foo'
        ]);

        $dealership = Dealership::factory()->create([
            'franchise_id' => $franchise->id
        ]);

        $vehicle = Vehicle::factory()->create([
            'dealership_id' => $dealership->id
        ]);

        $this->assertEquals($franchise->name, $vehicle->dealership->franchise->name);
    }

    public function testGetFranchiseEnpoint()
    {
        tenant()->update(['tier' => 'pro']);
        $franchise = Franchise::factory()->create([
            'name' => 'foo',
            'slug' => 'baz'
        ]);

        $response = $this->asTenant(tenant())
            ->getJson(route('franchises.show', $franchise->slug));

        $response->assertStatus(200);
        $this->assertArrayHasKey('name', $response->json());
        $this->assertArrayHasKey('slug', $response->json());
        $this->assertArrayHasKey('logo', $response->json());
        $this->assertArrayHasKey('primary_colour', $response->json());
        $this->assertArrayHasKey('secondary_colour', $response->json());
        $this->assertArrayHasKey('menus', $response->json());
    }
}
