<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Franchise;

class LiveChatFactory
{
    public function widget(array $live_chat_data): array
    {
        return match ($live_chat_data['name']) {
            'moneypenny' => $this->moneypennyWidget($live_chat_data),
            default => $live_chat_data,
        };
    }

    protected function moneypennyWidget(array $live_chat_data): array
    {
        $live_chat_data['key'] = Settings::get('chat-moneypenny-key', '');
        $live_chat_data['data']['franchise_keys'] = [];

        Franchise::all()->each(function ($franchise) use (&$live_chat_data) {
            $key = $franchise->data['chat-moneypenny-franchise-key'] ?? '';
            $live_chat_data['data']['franchise_keys'][$franchise->slug] = $key;
        });

        return $live_chat_data;
    }
}
