<?php

namespace App\Traits;

use App\Facades\Settings;
use Illuminate\Database\Eloquent\Model;

trait HasCarAndDrivingVideo
{
    public function isCarAndDrivingEnabled(): bool
    {
        return (bool)Settings::get('app-content-car-and-driving-enabled');
    }

    public function getCarAndDrivingVideoUrl(Model $model): ?string
    {
        if (empty($model->cap_id)) {
            return null;
        }

        $query = http_build_query([
            'user_id' => Settings::get('app-content-car-and-driving-user-id'),
            'capid' => $model->cap_id,
            'what' => 'video',
            'video_width' => Settings::get('app-content-car-and-driving-video-width'),
        ]);

        return "https://www.caranddriving.com/ws/a041/helper/helper.aspx?{$query}";
    }
}
