<?php

namespace App\Traits;

use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

trait CacheObject
{
    protected function cache(string $key, int $lifetime, \Closure $closure, string $tag = null)
    {
        $cacheInstance = $tag ? Cache::tags(tenant('id') . '-' . $tag) : Cache::store();

        return $cacheInstance->remember(tenant('id') . '-' . $key, $this->cacheLife($lifetime), $closure);
    }

    private function cacheLife(int $lifetime): Carbon
    {
        return Carbon::now()->addMinutes(app()->environment('production') ? $lifetime : 0);
    }
}
