<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\MediaSize;

trait MediaHasSizes
{
    private function allSizesForUse(Model $model, MediaUse $mediaUse): Collection
    {
        $this->mediaSizes = Cache::remember(
            tenant('id') . '-media-size-collection-' . $mediaUse->getOwnerType(),
            now()->addHour(),
            fn() => MediaSize::query()->where('model', $mediaUse->getOwnerType())->get()
        );

        return $this->mediaSizes
            ->keyBy('label')
            ->map(fn(MediaSize $size) => $mediaUse->getUrl($size->label));
    }
}
