<?php

namespace App\Http\Controllers;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use App\Traits\CacheObject;
use Illuminate\Http\Request;

class SiteController extends Controller
{
    use CacheObject;

    /**
     * Show page detail
     *
     * @param $page
     * @return SiteResource
     */
    public function index(): SiteResource
    {
        return $this->cache('site-resource', 5, fn() => new SiteResource([]));
    }

    public function checkAccess(Request $request)
    {
        return $request->input('password') === Settings::get('site-access-password')
            ? response('Access Granted')
            : response('Access Denied', 403);
    }
}
