<?php

namespace App\Http\Resources;

use App\Facades\Settings;

trait PhoneNumberDisplay
{
    public function displayNumber(string $number): string
    {
        return match (Settings::get('app-phone-number-format')) {
            '3-3-4' => substr($number, 0, 3) . ' ' . substr($number, 3, 3) . ' ' . substr($number, 6),
            '4-3-3' => substr($number, 0, 4) . ' ' . substr($number, 4, 3) . ' ' . substr($number, 7),
            default => $number
        };
    }
}
