<?php

namespace App;

use App\Http\Resources\OfferListResource;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Contracts\FilterObject;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferFilterObject implements FilterObject
{
    public function createQuery(): Builder
    {
        return VehicleOffer::query()
            ->active()
            ->withRelationshipsForCardView();
    }

    public function getResults(Builder $query): LengthAwarePaginator
    {
        return $query->paginate(Config::get('filter.result_page_limit'));
    }

    public function format(LengthAwarePaginator $results): JsonResource
    {
        return new OfferListResource($results);
    }

    public function applyFilter(Builder $query): void
    {
        $query->active();
    }

    public function sortOptionName(): string
    {
        return 'offers';
    }
}
