<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use App\Modules\Valuation\Config\AutoTrader;
use App\Modules\Valuation\Config\CapConfig;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\FilterSettingSeed;
use Tests\TestCase;
use Tests\TestValuationRepository;

class ValuationTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testNewRequest()
    {
        $this->app->bind('valuation-repository', TestValuationRepository::class);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-auto-trader-enabled',
            'value' => true,
            'type' => 'bool',
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'auto-trader-advertiser-id',
            'value' => 'abc-123',
            'type' => 'string',
        ]);

        $response = $this->asTenant(tenant())
            ->postJson(route('valuations.get'));

        $response->assertStatus(422);
        $this->assertArrayHasKey('registration_number', $response->json('errors'));
        $this->assertArrayHasKey('mileage', $response->json('errors'));

        $response = $this->asTenant(tenant())
            ->postJson(route('valuations.get'), [
                'registration_number' => 'FOO11BAZ',
                'mileage' => 60123
            ]);
        $response->assertStatus(201);
        $this->assertArrayHasKey('make', $response->json());
        $this->assertArrayHasKey('model', $response->json());
        $this->assertArrayHasKey('retailPrice', $response->json());
    }
}
