<?php

namespace App\Http\Controllers;

use App\Http\Requests\ValuationRequest;
use App\Http\Resources\ValuationResource;
use Illuminate\Support\Facades\Auth;
use Mtc\VehicleValuation\Facades\Valuation;

class ValuationController extends Controller
{
    public function get(ValuationRequest $request): ValuationResource
    {
        $valuation = Valuation::get($request->input('registration_number'), $request->input('mileage'));
        if ($valuation->wasRecentlyCreated) {
            $valuation->update([
                'user_id' => Auth::id(),
            ]);
        }
        return new ValuationResource($valuation);
    }
}
