<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Page;

class DealershipList extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'dealerships' => $this->resource->map(fn (Dealership $dealership) => $this->mapDealership($dealership)),
            'page' => new PageResource(Page::query()->where('slug', 'locations')->first()),
        ];
    }

    public function mapDealership(Dealership $dealership)
    {
        $coords = explode(',', $dealership->coordinates);
        return [
            'name' => $dealership->name,
            'address' => collect([
                $dealership->address1,
                $dealership->address2,
                $dealership->city,
                $dealership->postcode,
            ])->filter()->implode(', '),
            'open' => $dealership->is_open,
            'openStart' => $dealership->opens_at,
            'openEnd' => $dealership->closes_at,
            'openDays' => [],
            'coords' => [
                'lat' => $coords[0] ?? null,
                'lng' => $coords[1] ?? null,
            ],
            'url' => '/locations/' . $dealership->slug,
        ];
    }
}
