<?php

namespace App\Http\Resources;

use App\TierHelper;
use Mtc\MercuryDataModels\Franchise;

trait FranchiseData
{
    protected function isFranchise(): bool
    {
        if (TierHelper::isAllowed(tenant()->tier, 'pro') === false) {
            return false;
        }

        if (empty($this->resource)) {
            return false;
        }

        // TODO: figure out this properly
        return $this->resource?->template?->slug === 'franchise';
    }

    protected function franchiseData(): ?array
    {
        if ($this->isFranchise() !== true) {
            return null;
        }

        return Franchise::query()->find($this->getFranchiseId())
            ?->only([
                'name',
                'slug',
                'logo',
                'primary_colour',
                'secondary_colour',
                // 'dark',
                // 'type',
            ]);
    }


    protected function getFranchiseId(): int
    {
        return 0;
    }
}
