<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\VehicleMake;

class MakeListResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource->through(fn(VehicleMake $record) => $this->map($record));
        } else {
            $this->resource = $this->resource->map(fn(VehicleMake $record) => $this->map($record));
        }
        return parent::toArray($request);
    }

    protected function map(VehicleMake $record)
    {
        return [
            'name' => $record->name,
            'image' => $record->logo,
            'url' => $record->filterIndex->slug
        ];
    }
}
