<?php

namespace App\Http\Resources;

use App\VehicleRepository;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class PageListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn ($page) => $this->mapPage($page));
        } else {
            $this->resource = $this->resource
                ->map(fn($page) => $this->mapPage($page));
        }

        return parent::toArray($request);
    }

    public function mapPage($page): array
    {
        return [
            'url' => $this->getPageUrl($page),
            'title' => $page->title,
            'thumbnail' => $page->primaryMediaUse?->getUrl('332x332'),
            'date' => $page->published_at?->format('F j, Y'),
        ];
    }

    private function getPageUrl($page): string
    {
        return '/' . collect([
                $page->category,
                $page->slug
            ])->filter()
            ->implode('/');
    }
}
