<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use App\IntegrationRepository;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Menu;
use Mtc\MercuryDataModels\SeoRedirect;

class SiteResource extends JsonResource
{
    use FranchiseData;

    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $integrations = new IntegrationRepository();

        $menus = Menu::query()
            ->with('entries.children.children.children')
            ->get()
            ->keyBy('slug');

        return [
            'id' => tenant('id'),
            'name' => Settings::get('app-name'),
            'locale' => 'en-GB',
            'currency' => Settings::get('app-details-currency'),
            'favicon' => Settings::get('site-favicon'),
            'apple-touch' => Settings::get('site-apple-touch-icon'),
            'suspended' => tenant('suspended_at'),
            'branding' => [
                'primaryColour' => Settings::get('app-primary-colour'),
                'secondaryColour' => Settings::get('app-secondary-colour'),
                'tertiaryColour' => Settings::get('app-tertiary-colour'),
                'successColour' => Settings::get('app-success-colour'),
                'errorColour' => Settings::get('app-error-colour'),
                'informationColour' => Settings::get('app-information-colour'),
                'textColour' => Settings::get('app-text-colour'),
                'subTextColour' => Settings::get('app-subtext-colour'),
                'layerDarkColour' => Settings::get('app-layer-dark-colour'),
                'layerAccentColour' => Settings::get('app-layer-accent-colour'),
                'layerLightColour' => Settings::get('app-layer-light-colour'),
            ],
            'redirects' => SeoRedirect::query()
                ->select(['from', 'to', 'code'])
                ->get(),
            'header' => [
                'isFranchise' => $this->isFranchise(),
                'franchise' => $this->franchiseData(),
                'siteName' => Settings::get('app-name'),
                'logo' => Settings::get('site-logo'),
                'mainMenu' => new MenuResource($menus['header-main'] ?? []),
                'sidebarMenu' => new MenuResource($menus['header-sidebar'] ?? []),
            ],
            'footer' => [
                'logo' => Settings::get('site-logo'),
                'menu' => new MenuResource($menus['footer'] ?? []),
                'copyright' => 'Lorem ipsum dolor sit amet',
                'socials' => $integrations->findNonEmptyValuesForType('socials')
                    ->map(fn ($link, $key) => [
                        'key' => $key,
                        'url' => $link,
                    ])->values(),
                'subscribe' => [
                    'enabled' => $integrations->getEnabledForType('newsletters')->isNotEmpty(),
                ],

            ],
            'liveChat' => $this->liveChat(),
        ];
    }
    private function liveChat(): ?LiveChatResource
    {
        if ($this->hasLiveChatEnabled() === false) {
            return null;
        }

        return $this->getEnabledLiveChatWidget();
    }

    private function hasLiveChatEnabled(): bool
    {
        return (new IntegrationRepository())->getEnabledForType('chat')->isNotEmpty();
    }

    private function getEnabledLiveChatWidget(): LiveChatResource
    {
        return new LiveChatResource((new IntegrationRepository())->getEnabledForType('chat')->first());
    }
}
