<?php

namespace App\Http\Resources;

use App\PageRepository;
use Illuminate\Http\Resources\Json\JsonResource;

class UiArticlesSlider extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $articleType = $this->resource->subContent
            ->where('slug', 'article-type')
            ->first();

        return [
            'name' => $this->resource->name,
            'items' => new PageListResource((new PageRepository())->listing($articleType->content['value'] ?? null))
        ];
    }
}
