<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\VehicleMake;

class UiBrands extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return VehicleMake::query()
            ->with('filterIndex')
            ->whereIn('id', $this->resource->content ?? [])
            ->get()
            ->map(fn (VehicleMake $make) => [
                'name' => $make->name,
                'image' => $make->logo,
                'url' => $make->filterIndex->slug,
            ]);
    }
}
