<?php

namespace App\Sales;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Vehicle;

class SilverBullet
{
    public function getVehicleAction(Vehicle $vehicle, string $dealType = '')
    {
        return [
            'type' => 'component',
            'value' => 'SilverBulletDeal',
            'data' => [
                'title' => __('Build my deal'),
                'url' => $this->url(Settings::get('sales-silver-bullet-domain'), $dealType),
                'vehicle_id' => $vehicle->uuid,
                'dealer_id' => $vehicle->dealership_id,
                'utm_source' => Settings::get('sales-silver-bullet-domain'),
                'utm_medium' => Settings::get('sales-silver-bullet-medium'),
                'utm_campaign' => Settings::get('sales-silver-bullet-campaign-name'),
                'vehicle_url' => '',
            ]
        ];
    }

    /**
     * Deal building url. Determined by type
     *
     * @param string|null $domain
     * @param string $dealType
     * @return string
     */
    private function url(?string $domain, string $dealType): string
    {
        return match ($dealType) {
            'finance' => rtrim($domain, '/') . '/start-finance/',
            'trade-in' => rtrim($domain, '/') . '/start-trade-in/',
            default => rtrim($domain, '/') . '/start/',
        };
    }
}
