<?php

namespace Tests\Feature;

use App\Models\FilterIndex;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;

class OfferControllerTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testListOffers()
    {
        Page::factory()->create(['slug' => 'offers']);
        $make = VehicleMake::factory()->create();
        $index = FilterIndex::factory()->create([
            'filter_id' => $make->id,
            'filter_type' => 'make',
        ]);

        VehicleOffer::factory(5)
            ->create([
                'make_id' => $make->id,
                'published_at' => Carbon::now()->subDays(3),
            ]);
        VehicleOffer::factory(3);
        $response = $this->asTenant(tenant())
            ->postJson(route('offers.index', $index->slug));

        $response->assertStatus(200);
        $this->assertArrayHasKey('page', $response->json());
        $this->assertArrayHasKey('featured', $response->json());
        $this->assertArrayHasKey('makes', $response->json());
        $this->assertArrayHasKey('models', $response->json());
    }

    public function testShowOffer()
    {
        $offer = VehicleOffer::factory()->create();
        $response = $this->asTenant(tenant())
            ->getJson(route('offers.show', $offer));

        $response->assertStatus(200);
    }
}
