<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Menu;

class FranchiseResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load([
            'menus.element.fields',
            'menus.rootEntries.children.children.children',
            'menus.rootEntries.mediaUses.media'
        ]);

        $resource = $this->resource->only([
            'name',
            'slug',
            'logo',
            'primary_colour',
            'secondary_colour',
            'menus',
        ]);
        $resource['menus'] = $this->resource->menus->map(fn(Menu $menu) => new MenuResource($menu));

        return $resource;
    }
}
