<?php

namespace App\Traits;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\VehicleModel;

trait ModelsForMakeInSearch
{
    protected function getModelsForMake(?int $makeId, ?string $requiredActiveRelationship = null): Collection
    {
        if (!$makeId) {
            return collect();
        }

        return VehicleModel::query()
            ->where('make_id', $makeId)
            ->when(
                $requiredActiveRelationship,
                fn($query) => $query->whereHas($requiredActiveRelationship, fn ($query) => $query->active())
            )
            ->get()
            ->map(fn ($model) => [
                'code' => $model->slug ?? '',
                'label' => $model->name,
            ])
            ->prepend([
                'code' => null,
                'label' => 'All',
            ]);
    }
}
