<?php

namespace Tests\Data;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FinanceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Representative Finance Term',
                'config_key' => 'finance-term',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 60,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Representative Finance Annual Mileage',
                'config_key' => 'finance-annual_mileage',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 10000,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Representative Finance Deposit Percentage',
                'config_key' => 'finance-deposit_percentage',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Representative Finance Credit rating',
                'config_key' => 'finance-credit_rating',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => 'excellent',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Export to finance',
                'config_key' => 'finance-export-to-provider',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'iVendi Finance Enabled',
                'config_key' => 'finance-ivendi-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'iVendi Finance API Key',
                'config_key' => 'finance-ivendi-api_key',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-ivendi-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'CodeWeavers Finance Enabled',
                'config_key' => 'finance-codeweavers-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'CodeWeavers Finance API Key',
                'config_key' => 'finance-codeweavers-api_key',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-codeweavers-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'CodeWeavers Finance API Username',
                'config_key' => 'finance-codeweavers-username',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-codeweavers-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'CodeWeavers Finance API Password',
                'config_key' => 'finance-codeweavers-password',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-codeweavers-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'CodeWeavers Finance Dealer Name',
                'config_key' => 'finance-codeweavers-dealer_name',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-codeweavers-enabled,true"
                ]
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance Enabled',
                'config_key' => 'finance-evolution-enabled',
                'min_tier' => 'standard',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance API Client ID',
                'config_key' => 'finance-evolution-client_id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-evolution-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance API Client Password',
                'config_key' => 'finance-evolution-client_password',
                'min_tier' => 'standard',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.finance-evolution-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance HP Calculation value',
                'config_key' => 'finance-evolution-hp_calculation_value',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 0,
                'validation_rules' => [
                    "required_if:values.finance-evolution-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance PCP Calculation Value',
                'config_key' => 'finance-evolution-pcp_calculation_value',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 0,
                'validation_rules' => [
                    "required_if:values.finance-evolution-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'Evolution Funding',
                'name' => 'Evolution Funding Finance Calculation Type',
                'config_key' => 'finance-evolution-calculation_type',
                'min_tier' => 'standard',
                'type' => 'int',
                'value' => 3,
                'choices' => '{3:"APR Calculation",4:"Dealer Representative Calculation",'
                    . '5:"Dealer Typical APR Calculation"}',
                'validation_rules' => [
                    "required_if:values.finance-evolution-enabled,true"
                ]
            ],
        ];
    }
}
