<?php

namespace Tests\Data;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PeterVardyFinanceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Vehicle Finance Type',
                'config_key' => 'vehicle-finance-type',
                'min_tier' => 'enterprise',
                'type' => 'string',
                'value' => '',
                'description' => 'Specify custom handling of a default finance provider.<br/>',
            ],
        ];
    }
}
