<?php

namespace App;

use App\Repositories\RecentlyViewed;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;

class CrossSell
{
    public function __construct(private RecentlyViewed $recentlyViewed)
    {
        //
    }

    /**
     * Get cross-sell vehicle promotions
     *
     * @param Request $request
     * @param Vehicle $current
     * @return array
     */
    public function get(Request $request, Vehicle $current): array
    {
        if ($this->canRetrieveRecentlyViewed($request)) {
            return $this->recentlyViewed($current);
        }

        return $this->featured();
    }

    /**
     * Check if we can give recently viewed items
     *
     * @param Request $request
     * @return bool
     */
    private function canRetrieveRecentlyViewed(Request $request): bool
    {
        // TODO: Figure out how to have user sessions with no auth
        return false;
    }

    /**
     * Get recently viewed vehicles
     *
     * @param Vehicle $current
     * @return array
     */
    private function recentlyViewed(Vehicle $current): array
    {
        return [
            'type' => 'recently-viewed',
            'items' => $this->query()
                ->whereIn('id', $this->recentlyViewed->get('vehicles', $current->id))
                ->get()
        ];
    }

    /**
     * Get featured vehicles
     *
     * @return array
     */
    private function featured(): array
    {
        return [
            'type' => 'featured',
            'items' => $this->query()
                ->where('featured', 1)
                ->inRandomOrder()
                ->get()
        ];
    }

    /**
     * Prepare vehicle query
     *
     * @return Builder
     */
    private function query(): Builder
    {
        return Vehicle::query()
            ->take(4)
            ->with([
                'mediaUses.media',
                'make',
                'dealership',
            ]);
    }
}
