<?php

namespace App\Http\Controllers;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use Mtc\ContentManager\Models\Menu;

class SiteController extends Controller
{
    /**
     * Show page detail
     *
     * @param $page
     * @return SiteResource
     */
    public function index(): SiteResource
    {
        return new SiteResource([
            'id' => tenant('id'),
            'name' => Settings::get('app-name'),
            'suspended' => tenant('suspended_at'),
            'menus' => Menu::query()->with('entries.children.children.children')->get()

        ]);
    }
}
