<?php

namespace App\Http\Controllers;

use App\CrossSell;
use App\Http\Resources\VehicleList;
use App\Http\Resources\VehicleResource;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Vehicle;
use App\Repositories\RecentlyViewed;

class VehicleController extends Controller
{
    /**
     * Show vehicle FPA details
     *
     * @param Vehicle $vehicle
     * @return array
     */
    public function show(Request $request, Vehicle $vehicle, RecentlyViewed $recentlyViewed)
    {
        $recentlyViewed->add('vehicles', $vehicle->id);
        // TODO: Cross sell should get labels & config from Global content that manages behaviour
        $crossSellItems = (new CrossSell($recentlyViewed))->get($request, $vehicle);
        return [
            'data' => new VehicleResource($vehicle),
            'cross_sell' => [
                'type' => $crossSellItems['type'],
                'items' => new VehicleList($crossSellItems['items']),
            ],
        ];
    }
}
