<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;
use Mtc\Crm\Models\Form;

class SubmitEnquiryRequest extends FormRequest
{
    /** @var Form $form */
    private $form;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge([
            'form_id' => [
                'required',
                'numeric',
                'exists:forms,id',
            ],
        ], $this->questionSpecificRules());
    }

    public function attributes()
    {
        return $this->form()
            ->questions
            ->keyBy(fn($question) => "questions.$question->id")
            ->map(fn ($question) => $question->name)
            ->filter()
            ->toArray();
    }

    /**
     * @return array
     */
    protected function questionSpecificRules(): array
    {
        if (empty($this->form())) {
            // no form found - no question rules. will fail form validation
            return [];
        }

        return $this->form()
            ->questions
            ->keyBy(fn($question) => "questions.$question->id")
            ->map(fn ($question) => $question->validation)
            ->filter()
            ->toArray();
    }

    /**
     * Get the form object from request
     *
     * @return Form|null
     */
    public function form(): ?Form
    {
        if (empty($this->form)) {
            $this->form = Form::query()
                ->with('questions')
                ->find($this->input('form_id'));
        }

        return $this->form;
    }
}
