<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Dealership;

class DealershipList extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->each(function (Dealership $dealership) {
            $dealership->getIsOpenAttribute();
            $dealership->getOpensAtAttribute();
            $dealership->getClosesAtAttribute();
            $dealership->setVisible([
                'slug',
                'name',
                'address1',
                'address2',
                'city',
                'county',
                'postcode',
                'country',
                'is_open',
                'opens_at',
                'closes_at',
                'coordinates',
            ]);

        });
        return parent::toArray($request);
    }
}
