<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DealershipView extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->openTimes();
        return parent::toArray($request);
    }

    private function openTimes()
    {
        $openTimes = $this->resource->open_times ?? [];

        foreach (range(1, 7) as $weekday) {
            if (!isset($openTimes[$weekday])) {
                $openTimes[$weekday] = [];
            }
            $openTimes[$weekday]['weekday'] = __('calendar.weekdays.' . $weekday);
        }

        $this->resource->open_times = $openTimes;
    }
}
