<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Vehicle;

class VehicleList extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource
                ->through(fn ($vehicle) => $this->mapVehicle($vehicle));
        } else {
            $this->resource = $this->resource
                ->map(fn($vehicle) => $this->mapVehicle($vehicle));
        }

        return parent::toArray($request);
    }

    public function mapVehicle(Vehicle $vehicle)
    {
        return [
            'id' => $vehicle->id,
            'title' => $vehicle->title,
            'derivative' => $vehicle->derivative,
            'slug' => $vehicle->slug,
            'is_new' => $vehicle->is_new,
            'price' => $vehicle->price,
            'monthly_price' => $vehicle->monthly_price,
            'make_id' => $vehicle->make_id,
            'thumbnail' => [
                'small' => $vehicle->getPreviewImage('250x190'),
            ],
            'make' => [
                'name' => $vehicle->make->name ?? '',
                'logo' => $vehicle->make->logo ?? '',
            ],
            'location' => $vehicle->dealership->name ?? '',
            'deposit' => $vehicle->deposit,
        ];
    }
}
