<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class VehicleResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->fuel_type = $this->resource->fuelType?->name;
        $this->resource->transmission = $this->resource->transmission?->name;
        $this->resource->body_style = $this->resource->bodyStyle?->name;
        $this->resource->load('mediaUses.media');
        $this->resource->media_uses = $this->resource->mediaUses->map(fn($mediaUse) => [
            'title' => $mediaUse->title,
            'alt_text' => $mediaUse->alt_text,
            'description' => $mediaUse->description,
            'caption' => $mediaUse->caption,
            'src_large' => $mediaUse->getUrl('900x600'),
            'src_medium' => $mediaUse->getUrl('440x295'),
            'type' => $mediaUse->media->type
        ]);

        $this->resource->dealership = $this->resource->dealership?->only([
            'slug',
            'name',
            'contact_no',
            'open_time_text',
        ]);

        return $this->resource->only([
            'title',
            'odometer_mi',
            'odometer_km',
            'price',
            'monthly_price',
            'transmission',
            'fuel_type',
            'registration_number',
            'engine_size_cc',
            'seats',
            'colour',
            'media_uses',
            'dealership',
        ]);
    }
}
