<?php

namespace App\Seo;

use Illuminate\Support\Facades\DB;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\SeoMatchingMechanism;
use Mtc\MercuryDataModels\SeoData;

class MatchApproximateUrl implements SeoMatchingMechanism
{
    /**
     * Perform a check if this mechanism should be used for setting up SEO
     * data for the page
     *
     * @param FilterInstance $filter
     * @return bool
     */
    public function matchesRequest(FilterInstance $filter): bool
    {
        return SeoData::query()
            ->whereRaw(DB::raw("'{$filter->getPageUrl(false)}' LIKE CONCAT(`path`, \"%\")"))
            ->exists();
    }

    /**
     * Obtain SEO data for given filter object/page
     *
     * @param FilterInstance $filter
     * @return array
     */
    public function getData(FilterInstance $filter): array
    {
        $page = SeoData::query()
            ->whereRaw(DB::raw("'{$filter->getPageUrl(false)}' LIKE CONCAT(`path`, \"%\")"))
            ->first();


        return [
            'title' => $page->title ?? '',
            'description' => $page->description ?? '',
            'heading' => $page->heading ?? '',
        ];
    }
}
