<?php

declare(strict_types=1);

use App\Http\Controllers\DealershipController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\FilterController;
use App\Http\Controllers\LayoutController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\VehicleController;
use App\Http\Middleware\PreventRequestsIfTenantSuspended;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use App\Middleware\InitializeTenancyByDomain;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'api',
    \Stancl\Tenancy\Middleware\InitializeTenancyByRequestData::class
//    InitializeTenancyByDomain::class,
//    PreventRequestsIfTenantSuspended::class
])->prefix('frontend/')->group(function (Router $router) {

    $router->get('/get-site', [SiteController::class, 'index'])->name('get-site');

    $router->post('/newsletter', [NewsletterController::class, 'store'])->name('newsletter-signup');
    $router->post('/enquiries', [EnquiryController::class, 'store'])->name('enquiries.store');
    $router->get('/pages/{page:slug}', [PageController::class, 'show'])->name('pages.show');
    $router->get('/layout/site-layout', [LayoutController::class, 'siteLayout'])->name('layout.index');
    $router->get('/layout/menus/{menu}', [LayoutController::class, 'showMenu'])->name('layout.menu');

    $router->post('/find-vehicle', [FilterController::class, 'index'])->name('vehicles.index');
    $router->get('/vehicles/{vehicle:slug}', [VehicleController::class, 'show'])->name('vehicles.show');

    $router->post('/offers/{make}', [OfferController::class, 'index'])->name('offers.index');
    $router->get('/offers/{offer}', [OfferController::class, 'show'])->name('offers.show');

    $router->get('/dealerships', [DealershipController::class, 'index'])->name('dealerships.index');
    $router->get('/dealerships/{dealership:slug}', [DealershipController::class, 'show'])->name('dealerships.show');

});
