<?php

namespace App\Http\Resources;

use App\Facades\Feature;
use App\Facades\Settings;
use App\Modules\PlaceholderImages\ImaginStudio;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;

class LookupResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $image = null;
        if (
            Feature::isEnabled('imagin-studio-placeholders')
            && Settings::get('imagin-placeholders-valuation-lookup-enabled')
        ) {
            $image = App::make(ImaginStudio::class)->getForOther(
                $this->resource->make,
                $this->resource->model,
                $this->resource->colour
            );
        }

        return [
            'make' => $this->resource->make,
            'model' => $this->resource->model,
            'derivative' => $this->resource->derivative,
            'image' => $image,
            'registration' => $this->resource->registration_number,
            'mileage' => $this->resource->mileage,
            'manufacture_year' => $this->resource->manufacture_year,
            'fuelType' => $this->resource->fuel_type,
            'bodyType' => $this->resource->body_type,
            'transmission' => $this->resource->transmission,
        ];
    }
}
