<?php

namespace App\Http\Controllers;

use App\Facades\Site;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\Vehicle;

class VehicleDeeplinkController extends Controller
{
    public function autoTrader(string $at_id): Response
    {
        /** @var Vehicle|null $vehicle */
        $vehicle = Vehicle::query()->where('uuid', $at_id)->first();
        if (!$vehicle) {
            abort(404, 'Vehicle not found');
        }
        return response([
            'url' => Site::vehicleUrl($vehicle),
        ]);
    }

    public function vrm(string $vrm): Response
    {
        /** @var Vehicle|null $vehicle */
        $vehicle = Vehicle::query()->where('vrm_condensed', str_replace(' ', '', $vrm))->first();
        if (!$vehicle) {
            abort(404, 'Vehicle not found');
        }
        return response([
            'url' => Site::vehicleUrl($vehicle),
        ]);
    }
}
